/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.AncientBlazeEntity;
import java.util.Arrays;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AncientBlazeModel<T extends AncientBlazeEntity>
extends AdvancedEntityModel<T> {
    private static final int MAX_SHIELD_COUNT = 4;
    private static final int MAX_STICK_COUNT = 10;
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Shields;
    private final ModelPart Sticks;
    private final ModelPart[] shields;
    private final ModelPart[] sticks;

    public AncientBlazeModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.Shields = this.Body.m_171324_("Shields");
        this.shields = new ModelPart[4];
        Arrays.setAll(this.shields, number -> this.Shields.m_171324_("shield_" + number));
        this.Sticks = this.Body.m_171324_("Sticks");
        this.sticks = new ModelPart[10];
        Arrays.setAll(this.sticks, number -> this.Sticks.m_171324_("stick_" + number));
    }

    public void setupAnim(AncientBlazeEntity blaze, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int i;
        this.Head.f_104204_ = netHeadYaw * 0.017453f;
        this.Head.f_104203_ = headPitch * 0.017453f;
        float f = 0.785398f + ageInTicks * -0.094247f;
        for (i = 0; i < this.sticks.length; ++i) {
            this.sticks[i].f_104207_ = blaze.getShoots() > i;
            this.sticks[i].f_104201_ = Mth.m_14089_((float)(((float)i * 3.0f + ageInTicks) * 0.3f)) - 1.0f;
            this.sticks[i].f_104200_ = Mth.m_14089_((float)f) * 9.0f;
            this.sticks[i].f_104202_ = Mth.m_14031_((float)f) * 9.0f;
            f += 1.0f;
        }
        if (blaze.m_7090_()) {
            this.Shields.f_104204_ = 0.785398f;
            this.Head.f_104201_ = -22.5f;
            for (i = 0; i < this.shields.length; ++i) {
                this.shields[i].f_104200_ = Mth.m_14089_((float)((float)i * 1.570796f)) * 6.0f;
                this.shields[i].f_104202_ = Mth.m_14031_((float)((float)i * 1.570796f)) * 6.0f;
                this.shields[i].f_104203_ = 0.0f;
            }
        } else {
            this.Shields.f_104204_ = -ageInTicks / 50.0f;
            this.Head.f_104201_ = -24.5f;
            for (i = 0; i < this.shields.length; ++i) {
                this.shields[i].f_104200_ = Mth.m_14089_((float)((float)i * 1.570796f)) * 7.5f;
                this.shields[i].f_104202_ = Mth.m_14031_((float)((float)i * 1.570796f)) * 7.5f;
                this.shields[i].f_104203_ = -0.349065f;
            }
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(25, 24).m_171488_(-2.5f, -22.0f, -2.5f, 5.0f, 35.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-24.5f, (float)0.0f));
        PartDefinition Helmet = Head.m_171599_("Helmet", CubeListBuilder.m_171558_().m_171514_(33, 0).m_171488_(3.5f, -9.5f, -4.5f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(9, 17).m_171488_(-3.5f, -8.5f, -4.5f, 7.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(9, 22).m_171488_(-2.5f, -9.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(16, 22).m_171488_(0.5f, -9.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(23, 22).m_171488_(-3.5f, -10.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(9, 25).m_171488_(1.5f, -10.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(16, 25).m_171488_(0.5f, -11.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(23, 25).m_171488_(-2.5f, -11.5f, -4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(9, 28).m_171488_(-1.5f, -12.5f, -4.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 13).m_171488_(1.5f, -3.5f, -4.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 13).m_171488_(-3.5f, -3.5f, -4.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 0).m_171488_(-4.5f, -9.5f, -4.5f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(-2.5f, -8.5f, 3.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 36).m_171488_(-2.5f, -0.5f, 3.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(47, 13).m_171488_(2.5f, -9.5f, 3.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(47, 25).m_171488_(-3.5f, -9.5f, 3.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(18, 28).m_171488_(-2.5f, -4.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(33, 19).m_171488_(-0.5f, -7.5f, 3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(38, 19).m_171488_(-0.5f, -2.5f, 3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(47, 37).m_171488_(-1.5f, -6.5f, 3.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(47, 44).m_171488_(0.5f, -6.5f, 3.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(41, 24).m_171488_(1.5f, -4.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(52, 29).m_171488_(3.5f, -1.5f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(52, 21).m_171488_(3.5f, -8.5f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(52, 13).m_171488_(-4.5f, -8.5f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(46, 51).m_171488_(3.5f, -3.5f, -0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 39).m_171488_(-4.5f, -3.5f, -0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(47, 0).m_171488_(3.5f, -9.5f, 2.5f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(54, 0).m_171488_(-4.5f, -9.5f, 2.5f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(7, 40).m_171488_(-4.5f, -10.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(13, 31).m_171488_(3.5f, -10.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(13, 34).m_171488_(3.5f, -5.5f, -1.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(18, 34).m_171488_(-4.5f, -5.5f, -1.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(46, 55).m_171488_(3.5f, -5.5f, -0.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(46, 60).m_171488_(-4.5f, -5.5f, -0.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(52, 37).m_171488_(-4.5f, -1.5f, -2.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(52, 45).m_171488_(3.5f, -13.5f, -4.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(57, 45).m_171488_(-4.5f, -13.5f, -4.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(53, 51).m_171488_(2.5f, -15.5f, -4.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 51).m_171488_(-3.5f, -15.5f, -4.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Crystal = Head.m_171599_("Crystal", CubeListBuilder.m_171558_().m_171514_(25, 2).m_171488_(-1.5f, -11.5f, -4.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(27, 6).m_171488_(-3.5f, -9.5f, -4.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(27, 6).m_171488_(2.5f, -9.5f, -4.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Shields = Body.m_171599_("Shields", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-22.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        CubeListBuilder shieldForm = CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-5.0f, 0.0f, -1.0f, 10.0f, 19.0f, 2.0f, new CubeDeformation(0.0f));
        for (int i = 0; i < 4; ++i) {
            Shields.m_171599_("shield_" + i, shieldForm, PartPose.m_171423_((float)((float)i * 7.5f), (float)0.0f, (float)((float)i * 7.5f), (float)-0.3491f, (float)((float)(0xFFFFFFFF ^ i) * 1.570796f), (float)0.0f));
        }
        PartDefinition Sticks = Body.m_171599_("Sticks", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        CubeListBuilder stickForm = CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f));
        for (int i = 0; i < 10; ++i) {
            Sticks.m_171599_("stick_" + i, stickForm, PartPose.m_171419_((float)((float)i * 4.0f), (float)0.0f, (float)((float)i * 4.0f)));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

